
//var wsUri = "ws://"+location.hostname+":9015";
//var websocket = null;
var exportFileName = "";

function sendMessageNetwork(cmd,data) {

    var msg = cmd;

    if ( websocket != null )
    {
        var jsonmsg = {};

        jsonmsg.Command = msg;

        if(msg == "SetNetworkSetting"){
            jsonmsg = data;
        }
/*        else if(msg == "SetSystemSetting"){
            jsonmsg = data;
        } 
        else if(msg == "LoadProfile"){
            jsonmsg = data;
        }
        else if(msg == "SaveAsProfile"){
            jsonmsg = data;
        }*/
        if (websocket.readyState == 1) {
            websocket.send( JSON.stringify(jsonmsg) );
            //console.log( "string sent :", JSON.stringify(jsonmsg) );
        }
        else {
            //do something
            console.log( "websocket.readyState :", websocket.readyState );
            if(websocket.readyState == 3)
            {
                gWebSocketErrorBlockUIPage = true;
                blockUIforPage();
                setLoginStatus(false);
                gHadLogin = false;
                clearLoginStatus();
            }
        }
    }
}

function receivedDataNetwork(data) {

    var tempData = data;
    var obj = JSON.parse(tempData);

    //console.log('obj.Reply:',obj.Reply);

    switch (obj.Reply){

        case "GetNetworkSetting":
            updatedNetworkSetting(obj);
            /* if (gIsVideoStart == 1)
                updateNetworkTab(true);
            else
                updateNetworkTab(false); */
            updateNetworkTab(false);
            break;

        case "GetStandByStatus":
            updatedGetStandByStatus(obj);
            break;

        case "GetSoundMaxQtyProcessStatus":
            updatedGetSoundMaxQtyProcessStatus(obj);
            break;

        case "GetVideoIsStartStreaming":
            gIsVideoStart = getVideoStreamingStatus(obj);
            break;

        case "StartVideoStreaming":
            updatedStartVideoStreaming(obj,false);
            // updateNetworkTab(true);
            updateNetworkTab(false);
            break;

        case "StopVideoStreaming":
            updatedStopVideoStreaming(obj);
            updateNetworkTab(false);
            break;

        case "GetCurrentProfileID":
            updatedProfileIndex(obj);
            break;

        case "LoadProfile":
            if("Status" in obj)
            {
                if(obj.Status.includes("Finished"))
                {
                    sendMessageNetwork("GetCurrentProfileID");
                    UnblockUIforPage();
                }
            }
            break;

        case "SearchCamera":
            sendMessageNetwork("GetCurrentProfileID");
            UnblockUIforPage();
            break;

        case "SetNetworkSetting":
            
            if(obj.Status.includes("Finished"))
            {
                UnblockUIforPage();
            }
            break;
    }

}

function updatedNetworkSettingStatus(){
    var selectMethod;
    if(document.getElementById("selectMethod"))
    {
        selectMethod = document.getElementById("selectMethod").value;
        if(selectMethod == 0)
        {
            document.getElementById("ipTextInput").disabled = true;
            document.getElementById("netmaskTextInput").disabled = true;
            document.getElementById("gatewayTextInput").disabled = true;
            document.getElementById("DNSTextInput").disabled = true;
        }
        else
        {
            document.getElementById("ipTextInput").disabled = false;
            document.getElementById("netmaskTextInput").disabled = false;
            document.getElementById("gatewayTextInput").disabled = false;
            document.getElementById("DNSTextInput").disabled = false;
        }
    }

}

function updatedNetworkSetting(obj){

    $("#selectMethod").val(obj.Network.Method);    
    $("#ipTextInput").val(obj.Network.Address);
    $("#netmaskTextInput").val(obj.Network.Netmask);
    $("#gatewayTextInput").val(obj.Network.Gateway);
    $("#DNSTextInput").val(obj.Network.DNS);
    if(document.getElementById("MacAddressLabel"))
        document.getElementById("MacAddressLabel").innerText = obj.Network.Mac;
    if(document.getElementById("applyNetworkButton"))
        document.getElementById("applyNetworkButton").disabled = true;
    if(document.getElementById("cancelNetworkButton"))
        document.getElementById("cancelNetworkButton").disabled = true;

    updatedNetworkSettingStatus();
    document.getElementById("Select_Profile").style.display = "block";
    document.getElementById("Label_Profile").style.display = "block";

    if(isViewerLogin)
    {
        hideViewerBlock(false); 
    }
    else
    {
        hideViewerBlock(true); 
    }
}

function selectMethodOnChange() {

    updatedNetworkSettingStatus();

}

function initWebSocketNetwork() {

    if (websocket && websocket.readyState == 1) {
        console.log('Already connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageIndex("GetCurrentProfileID");
        sendMessageNetwork("GetVideoIsStartStreaming");
        sendMessageNetwork("GetNetworkSetting");
    }
    else
    {
        if(gProtocolStr == "http:")
            websocket = new WebSocket( wsUri );
        else
            websocket = new WebSocket( wssUri );
    }

    websocket.addEventListener('open', function() {
        console.log('open connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageIndex("GetCurrentProfileID");
        sendMessageNetwork("GetVideoIsStartStreaming");
        sendMessageNetwork("GetNetworkSetting");
    });

    websocket.addEventListener('message',function(evt){
        if(evt.data instanceof Blob)
        {
                
        }
        else
        {
            //console.log('Message received');
            receivedDataNetwork(evt.data);
        }
    });

    websocket.addEventListener('error',function(evt){
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    });

    websocket.onclose = function(evt) 
    {
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    };


}

function reloadNetwork() {
    openNetwork();
}

function onChangeNetworkApplyStatus(index){
    document.getElementById("applyNetworkButton").disabled = false;
    document.getElementById("cancelNetworkButton").disabled = false;
}

function NetworkApply(){

    var jsonmsg = {};

    var obj1 = {};
    
    jsonmsg.Command = "SetNetworkSetting";
    jsonmsg.Network = {};

    obj1.Method  = parseInt(document.getElementById("selectMethod").value,10);
    obj1.Address = document.getElementById("ipTextInput").value;
    obj1.Netmask = document.getElementById("netmaskTextInput").value;
    obj1.Gateway = document.getElementById("gatewayTextInput").value;
    obj1.DNS = document.getElementById("DNSTextInput").value;

    Object.assign(jsonmsg.Network, obj1);

    sendMessageNetwork("SetNetworkSetting",jsonmsg);

    blockUIforPage();
}

function NetworkCancel(){
    console.log('Cancel all unsaved settings...');
    sendMessageNetwork("GetVideoIsStartStreaming");
    sendMessageNetwork("GetNetworkSetting");
}

function openNetwork() {
    $("#DivMainPage").load("./page/network.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;

        initWebSocketNetwork();
        //tabPage();
        tabPageNetwork();
        $("#selectMethod").onchange

        document.getElementById("selectMethod").onchange     = function() {
            onChangeNetworkApplyStatus();
            updatedNetworkSettingStatus();
        };
        document.getElementById("ipTextInput").onchange         = function() {onChangeNetworkApplyStatus();};
        document.getElementById("netmaskTextInput").onchange    = function() {onChangeNetworkApplyStatus();};
        document.getElementById("gatewayTextInput").onchange    = function() {onChangeNetworkApplyStatus();};
        document.getElementById("DNSTextInput").onchange        = function() {onChangeNetworkApplyStatus();};
    });
}

function updateNetworkTab(status) {
    var selectMethod;
    if(document.getElementById("selectMethod"))
    {
        selectMethod = document.getElementById("selectMethod").value;
        if (selectMethod == 0) {
            // ip, netmask, gateway and dns always disabled
            document.getElementById("ipTextInput").disabled = true;
            document.getElementById("netmaskTextInput").disabled = true;
            document.getElementById("gatewayTextInput").disabled = true;
            document.getElementById("DNSTextInput").disabled = true;
        }
        else {
            // ip, netmask, gateway and dns change by status
            document.getElementById("ipTextInput").disabled = status;
            document.getElementById("netmaskTextInput").disabled = status;
            document.getElementById("gatewayTextInput").disabled = status;
            document.getElementById("DNSTextInput").disabled = status;
            // applyNetworkButton always disabled
            document.getElementById("applyNetworkButton").disabled = true;
            document.getElementById("cancelNetworkButton").disabled = true;
        }
        document.getElementById("selectMethod").disabled = status;
        // document.getElementById("Select_Profile").disabled = status;
    }
}

function tabPageNetwork(){
    sendMessageNetwork("GetNetworkSetting");
};
